function imgFeatures = extractLAB_RGBFeatures_geo_ext(imgPath, fgSample, bgSample, BI)
%EXTRACTLABFEATURES Summary of this function goes here
%   Detailed explanation goes here

    img_rgb = imread(imgPath);
    [L,A,B] = RGB2Lab(img_rgb);
    img_lab = zeros([size(img_rgb, 1) size(img_rgb, 2) 3]);
    img_lab(:,:,1) = L;
    img_lab(:,:,2) = A;
    img_lab(:,:,3) = B;

    % Normalize LAB
    L = L/100;
    A = (A+128)/256;
    B = (B+128)/256;
%     L = L - min(L(:));
%     A = A - min(A(:));
%     B = B - min(B(:));
%     L = L / max(L(:));
%     A = A / max(A(:));
%     B = B / max(B(:));
    
    img_lab_normalized = zeros([size(img_rgb, 1) size(img_rgb, 2) 3]);
    img_lab_normalized(:,:,1) = L;
    img_lab_normalized(:,:,2) = A;
    img_lab_normalized(:,:,3) = B;

    img_rgb_normalized = double(img_rgb)/255;

    [height, width, ~] = size(img_rgb);

    %% GeoDist from UNnormalized LAB/RGB channels
    
    fgDistTransform_lab = computeDistances(double(img_lab), fgSample');
    fgDistTransform_rgb = computeDistances(double(img_rgb), fgSample');
    fgDistWeighting_lab = 1 - fgDistTransform_lab / ((height + width - 2) * 255 * 3);
    fgDistWeighting_rgb = 1 - fgDistTransform_rgb / ((height + width - 2) * 255 * 3);
        
    bgDistTransform_lab = computeDistances(double(img_lab), bgSample');
    bgDistTransform_rgb = computeDistances(double(img_rgb), bgSample');
    bgDistWeighting_lab = 1 - bgDistTransform_lab / ((height + width - 2) * 255 * 3);
    bgDistWeighting_rgb = 1 - bgDistTransform_rgb / ((height + width - 2) * 255 * 3);

    %% GeoDist from normalized LAB/RGB channels
    
%     fgDistTransform_lab = computeDistances(double(img_lab_normalized), fgSample');
%     fgDistTransform_rgb = computeDistances(double(img_rgb_normalized), fgSample');
%     fgDistWeighting_lab = 1 - fgDistTransform_lab / ((height + width - 2) * 3);
%     fgDistWeighting_rgb = 1 - fgDistTransform_rgb / ((height + width - 2) * 3);
% 
%     bgDistTransform_lab = computeDistances(double(img_lab_normalized), bgSample');
%     bgDistTransform_rgb = computeDistances(double(img_rgb_normalized), bgSample');
%     bgDistWeighting_lab = 1 - bgDistTransform_lab / ((height + width - 2) * 3);
%     bgDistWeighting_rgb = 1 - bgDistTransform_rgb / ((height + width - 2) * 3);

%%

    fgFeatureVector_lab = bsxfun(@times, img_lab_normalized, ...
        fgDistWeighting_lab);
    bgFeatureVector_lab = bsxfun(@times, img_lab_normalized, ...
        bgDistWeighting_lab);
    fgFeatureVector_rgb = bsxfun(@times, img_rgb_normalized, ...
        fgDistWeighting_rgb);
    bgFeatureVector_rgb = bsxfun(@times, img_rgb_normalized, ...
        bgDistWeighting_rgb);
    imgFeatures = cat(3, fgFeatureVector_lab, bgFeatureVector_lab, ...
        fgFeatureVector_rgb, bgFeatureVector_rgb);

end

